<?php
/**
 * @package         Dunamis
 * @version         1.4.4
 *
 * @author          Go Higher Information Services, LLC
 * @link            https://www.gohigheris.com
 * @copyright       2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license         GNU General Public License version 2, or later
 */

defined('DUNAMIS') OR exit('No direct script access allowed');

/**
 * Dunamis Language handler for WHMCS
 * @desc		This permits our own translation to be used within WHMCS for the Dunamis Framework
 * @package		Dunamis
 * @subpackage	WHMCS
 * @author		Go Higher Information Services, LLC
 * @link		https://www.gohigheris.com
 * @copyright	2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license		GNU General Public License version 2, or later
 */
class WhmcsDunLanguage extends DunLanguage
{
	/**
	 * Constructor method
	 * @access		public
	 * @version		1.4.4
	 * @param		array		- $options: contains an array of arguments
	 *
	 * @since		1.0.0
	 */
	public function __construct( $options = array() )
	{
		parent :: __construct( $options );
		
		// Attempt to determine the language automatically
		$idiom	= $this->_findLanguage();
		$this->setIdiom( $idiom );
	}
	
	
	/**
	 * Method for determining which language we are using
	 * @access		private
	 * @version		1.4.4
	 * 
	 * @return		string
	 * @since		1.0.0
	 */
	private function _findLanguage()
	{
		if ( is_admin() ) {
			if ( array_key_exists( 'aInt', $GLOBALS ) ) {
				$aInt = $GLOBALS['aInt'];
				return $aInt->language;
			}
			else if ( array_key_exists( 'calanguage', $GLOBALS ) ) {
				return $GLOBALS['calanguage'];
			}
			else {
				return 'english';
			}
		}
		else {
			global $smarty;
			
			// In case we haven't initialized the system
			if (! is_object( $smarty ) ) return 'english';
			 
			$language	= $smarty->_tpl_vars['language'];
			return strtolower( $language );
		}
		
	}
	
}