<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'settings', 'logs')}</li>
</ul>

<table class="table table-hover table-striped" id="logslist">
    <thead>
        <tr>
            <th>{$MGLANG->T('table','name')}</th>
            <th>{$MGLANG->T('table','client')}</th>
            <th>{$MGLANG->T('table','action')}</th>
            <th>{$MGLANG->T('table','status')}</th>
            <th>{$MGLANG->T('table','value')}</th>
            <th>{$MGLANG->T('table','date')}</th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>
    
<div class="well">
    <a class="btn btn-danger btn-inverse" data-act="removeAllLogs" data-confirm-body="{$MGLANG->T('remove_all_logs_confirmation')}">{$MGLANG->T('delete_all_logs')}</a>
</div>           
          
{literal}
    <script data-cfasync="false" type="text/javascript">
        jQuery(document).ready(function(){
            var last;
            
            jQuery('#table-filters').change(function() {
                jQuery('#logslist').DataTable().ajax.reload();
            });
            
            jQuery('#logslist').dataTable({
                  drawCallback: replaceEmptyRowDataTable,
                  serverSide: true,
                //  searching: true,
                  searchDelay: 800,
                  autoWidth: false,
                  ajax: function(data, callback, settings){
                      if(last != data.length) {
                          data.start = 0;
                      }
                      last = data.length;
                      
                      var filters = [];//$('#table-filters :input').serializeArray();
                      JSONParser.request(
                          'refreshLogTable'
                          , $.merge(filters, [
                              {name: 'order[column]', value: data.columns[data.order[0].column].name},
                              {name: 'order[dir]', value: data.order[0].dir},
                              {name: 'limit', value: data.length},
                              {name: 'offset', value: data.start},
                              {name: 'search', value: data.search.value},
                          ])
                          , function(data) {
                              callback(data);
                              jQuery('.mg-wrapper [title]').bstooltip();
                              addCustomPagination('logslist');
                          }
                      );
                  },
                  columns: [
                      {name: 'name'}
                      ,{name: 'client'}
                      ,{name: 'action'}
                      ,{name: 'status'}
                      ,{name: 'value'}
                      ,{name: 'date'}
                  ],
                  order: [[5, "desc"]],
                  pagingType: "simple_numbers",
                  aLengthMenu: [
                      [5, 10, 25, 50, 75, 100],
                      [5, 10, 25, 50, 75, 100]
                  ],
                  iDisplayLength: 10,
                  //sDom: 't<"table-bottom"<"row"<"col-sm-6"p><"col-sm-6"L>>>',
                  "oLanguage": {
                        "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                        "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                        "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                        "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                        "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                        "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                        "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                        "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                        "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                   }
            });
            
        });
    </script>
{/literal}

