<div class="module-main-header">
    <a href="index.php?m=DNSManager2" class="btn btn-back btn-icon" style="height: inherit;"><i class="fa fa-arrow-left"></i></a><h2>{$MGLANG->T('dnsSetsTitle')}</h2>
</div>
<div class="module-content">
    <table class="table table-hover table-striped" id="setstable">
        <thead class="setsableTh">
            <tr>
                <th>{$MGLANG->T('table','name')}</th>
                <th>{$MGLANG->T('table','dns_records')}</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
{literal}
    <script data-cfasync="false" type="text/javascript">
        function refreshTable() {
            jQuery('#setstable').DataTable().ajax.reload();
        }
        
        function setSaveCallback(data, $obj) {refreshTable();}
        function removeSetCallback(data, $obj) {refreshTable();}
        
        function addNewRecordCallback(data, $obj) {
            if(!data.new_record) return false;
            $obj.parents('form').find('tr.nobody-is-here').hide();
            $obj.parents('form').first().find('.set-records table tbody').append(data.new_record);
            var $input = $obj.parents('.add-me-right-here').first().find('[name=records_counter]');
            $input.val(parseInt($input.val()) + 1);
        }
        
        function removeRecord($obj) {
            $('.mg-wrapper [title]').bstooltip('hide');
            var $tbody = $obj.parents('tbody');
            $obj.parents('tr').first().remove();
            if(!Boolean($tbody.find('tr:not(.nobody-is-here)').length)) {
                $tbody.find('tr.nobody-is-here').show();
            }
            return false;
        }
        jQuery('.breadcrumb li.active').text({/literal}'{$MGLANG->T('setsdns')}'{literal});
    </script>
{/literal}

{literal}
    <script data-cfasync="false" type="text/javascript">
        function dnsLoadButon(){
            if(!document.getElementById('addSetButton')){
                jQuery('#setstable_filter').children().last().after('<a class="btn btn-primary" id="addSetButton" style="" data-act="addSet">{/literal}{$MGLANG->T('add_set')}{literal}</a>');
                $($('#setstable_filter').find('input')).attr("placeholder","{/literal}{$MGLANG->T('search')}{literal}");
            }
        }
        
        function dnsLoadHeader(){
            if(!document.getElementById('pageheader')){
                jQuery('#setstable_filter').parent().append('<div id="pageheader" class=""><div class="myheader-title"><h1>{/literal}{$MGLANG->T('setsdns')}{literal}</h1></div>');
            }
        }
        
        jQuery(document).ready(function(){
            var last;
            
            jQuery('#table-filters').change(function() {
                jQuery('#setstable').DataTable().ajax.reload();
            });
            
            jQuery('#setstable').dataTable({
                  serverSide: true,
                  searchDelay: 800,
                  autoWidth: false,
                  ajax: function(data, callback, settings){
                      if(last != data.length) {
                          data.start = 0;
                      }
                      last = data.length;
                      
                      var filters = [];
                      JSONParser.request(
                          'list'
                          , $.merge(filters, [
                              {name: 'order[column]', value: data.columns[data.order[0].column].name},
                              {name: 'order[dir]', value: data.order[0].dir},
                              {name: 'limit', value: data.length},
                              {name: 'offset', value: data.start},
                              {name: 'search', value: data.search.value},
                          ])
                          , function(data) {
                              callback(data);
                              jQuery('.mg-wrapper [title]').bstooltip();
                              dnsLoadHeader();
                              dnsLoadButon();

                          }
                      );
                  },
                  columns: [
                      {name: 'name'}
                      ,{name: 'dnsrecords'}
                      ,{ orderable: false, targets: 0}
                  ],
                  pagingType: "simple_numbers",
                  aLengthMenu: [
                      [5, 10, 25, 50, 75, 100],
                      [5, 10, 25, 50, 75, 100]
                  ],
                  iDisplayLength: 10,
           //       "dom": '<"top"i>rt<"bottom"flp><"clear">',
                  dom: '<"top"f>rt<"bottom"pl><"clear">',
             //     sDom: '<"icon-search"r>',
                  "oLanguage": {
                        "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                        "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                        "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                        "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                        "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                        "sSearch": "",
                        "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                        "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                        "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                   }
            });
        });
    </script>
{/literal}