//ArVal v0.0.2
//Author: Artur Nowicki <artur.no@modulesgarden.com>

jQuery(document).ready(function() {
    jQuery('input[arval-button="1"], a[arval-button="1"], button[arval-button="1"]').click(function(){
        var form        = jQuery(this).closest("form");
        var is_error    = false;
        var perma_error = false;
        
        jQuery("[arval]", form).css('border-color', '');
        
        jQuery("[arval]", form).each(function() {
            var obj         = jQuery(this);
            var value       = jQuery(this).val();
            var conditions  = jQuery(this).attr("arval").split(",");
            
            jQuery.each(conditions, function(index, condition) {
                switch(condition) {
                    case "not-empty":
                        if(value === '') {
                            obj.css('border-color', 'red');
                            is_error = true;
                        }
                        break;
                    case "ipv4":
                        if(!value.match(/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/)) {
                            obj.css('border-color', 'red');
                            is_error = true;
                        }
                        break;
                    case "int":
                        if(Math.floor(value) != value || !jQuery.isNumeric(value)) {
                            obj.css('border-color', 'red');
                            is_error = true;
                        }
                        break;
                    case "allow-empty": //MUST BE as the last element
                        if(value === '') {
                            obj.css('border-color', '');
                            is_error = false;
                        }
                }
            });
            
            if(is_error === true) {
                perma_error = true;
            }
        });
   
        if(perma_error === false) {
            form.submit();
        } else {
            return false;
        }
    });
});