$(document).ready(function () {
    $("[name='my-checkbox']").bootstrapSwitch();
    $('#refreshReport').hide();
    var queryDiv = ace.edit("queryDiv");
    var phpDiv = ace.edit("phpDiv");
    var sortableIn;
    queryDiv.session.setMode("ace/mode/sql");
    phpDiv.session.setMode({path: "ace/mode/php", inline: true});
    getDataFromSession();

    var draggable = {
        helper: 'clone',
        revert: 'invalid',
        appendTo: 'body'
    };

    var sortable = {
        delay: 150,
        over: function (e, ui) {
            sortableIn = false;
        },
        out: function (e, ui) {
            sortableIn = true;
        },
        beforeStop: function (event, ui) {
            if (sortableIn) {
                $(ui.item).remove();
            }
            serializeFilters();
        }
    };

    var dropable = {
        drop: function (event, ui) {
            dropElementOnQueryArea(event, ui);
            $(this).removeClass("over");
            updateUI();
        },
        over: function (event, ui) {
            $(this).addClass("over");
        },
        out: function (event, ui) {
            $(this).removeClass("over");
        }
    };
    updateUI();
    function updateUI() {
        $("#filterDiv").sortable(sortable);
        $(".draggable").draggable(draggable);
        $(".ace_content").droppable(dropable);
        $("#filterDiv").sortable(sortable);
    }

    function dropElementOnQueryArea(event, ui) {
        var tableName = $(ui.draggable).attr('id');
        tableColumnsDropdown(tableName, 'containerField');
        $('#addFieldModal').modal('show');
    }

    function setAlerts(error, mainError) {
        if (error.length === 0) {
            return;
        }

        var target = $(".mg-error-container");
        if (mainError) {
            target = $("#mg-error-container");
        }

        var textObj = target.find('#text');
        $(textObj).html(error);
        target.show();
        setTimeout(function () {
            target.fadeOut('slow', function () {
                target.hide();
            });
        }, 7000);
    }

    function tableColumnsDropdown(tableName, targetDiv) {
        JSONParser.request('getTableColumns', {
            tableName: tableName
        },
                function (data) {
                    var dropdown = '<select id="tableColumns" table="' + tableName + '" class="form-control">';
                    $.each(data, function (index, value) {
                        dropdown += '<optgroup label="' + index + '">';
                        $.each(value, function (value2, index2) {
                            dropdown += '<option data-tableName="' + index + '" data-columnName="' + value2 + '" value="' + index + '.' + value2 + '">' + value2 + '</option>';
                        });
                        dropdown += '</optgroup>';
                    });
                    dropdown += '</select>';
                    $('#' + targetDiv).html(dropdown);
                });
    }

    function prepareFiltersModal() {
        $('#filterTypeDropdown').val('DateRangeFilter');
        addFilterHtmlToModal('DateRangeFilter', '', '', '');
    }

    function prepareFiltersModalForEdit(thisObj) {
        var filterType = $(thisObj).attr('data-filtertype');
        var filterTitle = $(thisObj).attr('data-filtertitle');
        var filterDescr = $(thisObj).attr('data-filterdescr');
        var filterOpts = $(thisObj).attr('data-filteroptions');

        $('#filterTypeDropdown').val(filterType);
        $('#filterTitle').val(filterTitle);
        $('#filterDescr').val(filterDescr);
        if (filterOpts) {
            $('#dropdownFilterValues').val(filterOpts);
            $('#dropdownFilterValuesDiv').show();
        } else {
            $('#dropdownFilterValuesDiv').hide();
        }

        var defaultVars = $(thisObj).attr('data-filterdefault');
        addFilterHtmlToModal(filterType, filterTitle, filterDescr, filterOpts, defaultVars);
    }

    function setDefaultVarsForFilter(defaultVars) {
        try {
            defaultVars = JSON.parse(defaultVars);

            if ($('#testName')) {
                $('#testName').val(defaultVars);
            }

            $(document.getElementsByName('filters[testName][from]')).val(defaultVars.from);
            $(document.getElementsByName('filters[testName][to]')).val(defaultVars.to);
        } catch (e) {
            $('#testName').val(defaultVars);
        }
    }

    function hideElementsByName(parentDiv, text, elementsClass) {
        text = text.toLowerCase();
        $(parentDiv).each(function () {
            if (!$(this).hasClass(elementsClass)) {
                return; //if not table element continue
            }

            var id = '';
            if ($(this).attr('id')) {
                id = $(this).attr('id');
            }

            var fName = $(this).text().toLowerCase();
            if (id.toLowerCase().indexOf(text) >= 0 || fName.indexOf(text) >= 0) {
                $(this).show();
            } else {
                $(this).hide();
            }

        });
    }

    function getFilterDataFromModal() {
        var data = {
            filtertype: $('#filterTypeDropdown option:selected').val(),
            filtertitle: $('#filterTitle').val(),
            filterdescr: $('#filterDescr').val(),
            filtername: makeID(),
            filterdefault: getFilterValueFromModal()
        };

        if (data.filtertype === 'DropdownFilter') {
            data['filteroptions'] = $('#dropdownFilterValues').val();
        }

        var ret = {
            data: data,
            filterName: $('#filterTypeDropdown  option:selected').text(),
        };
        return ret;
    }

    function getFilterValueFromModal() {
        var filtertype = $('#filterTypeDropdown option:selected').val();
        var filterData = [];
        switch (filtertype) {
            case 'DropdownFilter':
                filterData = $('#testName  option:selected').val();
                break;
            case 'DateRangeFilter':
                filterData = {
                    from: $('#testName-from').val(),
                    to: $('#testName-to').val()
                };
                filterData = JSON.stringify(filterData);

                break;
            case 'CronDateFilter':
                filterData = $('#testName option:selected').attr('data-value');
                break;
            case 'IntRangeFilter':
                filterData = {
                    from: $("[name='filters[testName][from]']").val(),
                    to: $("[name='filters[testName][to]']").val()
                };
                filterData = JSON.stringify(filterData);

                break;
            default :
                filterData = $('#testName').val();
                break;
        }

        return filterData;
    }

    function editFilter(editFilter) {
        var data = getFilterDataFromModal();
        //get old iltername instead of newly generated 
        data.data.filtername = editFilter.attr('data-filtername');

        $.each(data.data, function (name, value) {
            editFilter.attr('data-' + name, value);
        });

        $(editFilter).html(data.filterName + ': ' + data.data.filtername);
    }

    function addNewFilter() {
        var data = getFilterDataFromModal();
        var text = data.filterName + ': ' + data.data.filtername;
        addFilterToDiv(data.data, text);
    }

    function addFilterToDiv(data, text) {
        var html = '<div class="dropped well well-sm" ';

        $.each(data, function (name, value) {
            html += 'data-' + name + '=' + "'" + value + "'";
        });

        html += '>' + text + '</div>';
        $('#filterDiv').append(html);
        serializeFilters();
    }

    function putTextInCurrentQueryPosition(text) {
        queryDiv.insert(text);
    }

    function addFilterTextToQuery(thisObj) {
        var name = $(thisObj).attr('data-filtername');
        var simpleFilters = ['DropdownFilter', 'TextFilter'];
        var text = '<:' + name + '_from:> <:' + name + '_to:>';

        if (jQuery.inArray($(thisObj).attr('data-filtertype'), simpleFilters) !== -1) {
            text = '<:' + name + ':>';
        }

        putTextInCurrentQueryPosition(text);
    }

    function serializeFilters() {
        if (disabledAutoUpdate()) {
            return;
        }

        var filters = getFilters();
        JSONParser.request('addWhereToSession', {where: filters}, function (data) {});
    }

    function getDataFromSession() {
        JSONParser.request('getExpertDataFromSession', {},
                function (data) {
                    $('#title').val(data.title);
                    $('#chartDescr').val(data.descr);

                    console.log('getDataFromSession');
                    console.log(data);

                    if (data.query) {
                        queryDiv.setValue(data.query);
                    }
                    if (!data.usePHP) {
                        phpDiv.setReadOnly(true);
                    } else if(data.usePHP === 'true' && data.phpCode){
                      $('#usePHP').prop('checked', true);
                      phpDiv.setValue(data.phpCode);  
                    }

                    if (data.filters) {
                        addFiltersFromSession(data.filters);
                    }

                    generateReport();
                });
    }

    function addFiltersFromSession(filters) {
        console.log(filters);
        var text = '';
        $.each(filters, function (index, value) {
            if (value && value.hasOwnProperty('filterType')) {
                text = value.filterType + ': ' + value.filterName;
                addFilterToDiv(value, text);
            }
        });
    }

    function addFilterHtmlToModal(filterTypeDropdown, title, descr, opts, defaultVars) {
        JSONParser.request('getFilterHtml', {
            filter: filterTypeDropdown,
            title: title,
            descr: descr,
            options: opts
        },
                function (data) {
                    $('#filterHTML').html(data);
                    setDefaultVarsForFilter(defaultVars);
                });
    }

    function getFilters() {
//        if (disabledAutoUpdate()) {
//            return;
//        }

        var filters = new Array();
        $($('#filterDiv').children()).each(function () {
            if (!$(this).hasClass('ui-sortable-placeholder')) {
                var temp = {
                    filterdescr: $(this).attr('data-filterdescr'),
                    filtername: $(this).attr('data-filtername'),
                    filtertitle: $(this).attr('data-filtertitle'),
                    filtertype: $(this).attr('data-filtertype'),
                    filteroptions: $(this).attr('data-filteroptions'),
                    filterdefault: $(this).attr('data-filterdefault')
                };
                filters.push(temp);
            }
        });

        return filters;
    }

    function disabledAutoUpdate() {
        var state = $('#auto_update_onoff').bootstrapSwitch('state');
        //on button click always return false 
        if ($('#refreshReport').hasClass('manual')) {
            return false;
        }

        return  !state;
    }

    function generateReport() {
        if (disabledAutoUpdate()) {
            return;
        }

        var data = {
            usePHP: $('#usePHP').is(':checked'),
            title: $('#title').val(),
            descr: $('#chartDescr').val(),
            phpCode: phpDiv.getValue(),
            query: queryDiv.getValue()
        };

        console.log('genereate report data');
        console.log(data);

        JSONParser.request('showChartExpert', data,
                function (data) {
                    jQuery("#report").html(data.report);
                    jQuery("#report").show();
                    jQuery("#results").text(data.data);
                    $('#chartDescr').val(data.reportDescr);
                    $('#title').val(data.reportTitle);
                    $('[data-toggle="tooltip"]').tooltip();
                    if (data.err) {
                        setAlerts(data.err);
                    }
                });
    }

    function toggleRefreshButton(state) {
        if (state) {
            $('#refreshReport').hide();
        } else {
            $('#refreshReport').show();
        }
    }

    function makeID() {
        var text = "";
        var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (var i = 0; i < 7; i++)
            text += possible.charAt(Math.floor(Math.random() * possible.length));
        return text;
    }

    $(document).delegate('#usePHP', 'change', function (e) {
        if ($(this).is(":checked")) {
            phpDiv.setReadOnly(false);
        } else {
            phpDiv.setReadOnly(true);
        }

        if ($('#auto_update_onoff').bootstrapSwitch('state')) {
            generateReport();
        }
    });
    var timer;
    $("#title,#chartDescr,#queryDiv,#phpDiv").on('keyup', function () {
        var state = $('#auto_update_onoff').bootstrapSwitch('state');
        if (state) {
            clearTimeout(timer);
            timer = setTimeout(function () {
                serializeFilters();
                generateReport();
            }, 2000);
        }
    });

    $(document).delegate("#saveReport", "click", (function () {
        JSONParser.request('getReportTitleAndDescr', {},
                function (data) {
                    $('#reportTitle').val(data.title);
                    $('#reportDescription').val(data.descr);
                });
        $('#saveReportModal').modal('show');
    }));
    $(document).delegate('#addFilter', 'click', function () {
        prepareFiltersModal();
        $('#filtersModal input').val("");
        $('#filtersModal').modal('show');
    });
    $(document).delegate('.dropped', 'contextmenu', function (e) {
        e.preventDefault();
        $(this).addClass('edit');
        prepareFiltersModalForEdit(this);
        $('#filtersModal').modal('show');
        return false;
    });
    $(document).delegate('.dropped', 'mousedown', function (e) {
        if (e.which === 1) { //leftclick
            addFilterTextToQuery(this);
        }
    });
    $(document).delegate('#saveReportModalButton', 'click', function () {
        $('#saveReportModal').modal('hide');
        var reportData = {
            sectionName: makeID(),
            reportName: makeID(),
            sectionTitle: $('#reportTitle').val(),
            sectionDescr: $('#reportDescription').val(),
            reportTitle: $('#reportTitle').val(),
            reportDescr: $('#reportDescription').val(),
            phpCode: ''
        };
        if ($('#usePHP').is(':checked')) {
            reportData['phpCode'] = $('#phpCodeArea').text();
        }

        if (reportData['reportTitle'] === 'undefined') {
            reportData['reportTitle'] = 'TestTitle';
        }

        JSONParser.request('saveReportToFile', reportData,
                function (data) {
                    location.replace('addonmodules.php?module=reportgenerator&mg-page=start&mg-action=viewCustom&report=' + data['reportName']);
                });
    });
    $("#searchTables").on('keyup', function () {
        var text = $("#searchTables").val();
        var tableDiv = $('#tablesDiv').find('.well').children();
        hideElementsByName(tableDiv, text, 'draggable');
    });
    $('body').on('change', '#filterTypeDropdown', function (event) {
        var filterTypeDropdown = $('#filterTypeDropdown option:selected').val();
        var title = $('#filterTitle').val();
        var descr = $('#filterDescr').val();
        var opts = $('#dropdownFilterValues').val();

        if (filterTypeDropdown === 'DropdownFilter') {
            $('#dropdownFilterValuesDiv').show();
        } else {
            $('#dropdownFilterValuesDiv').hide();
        }

        addFilterHtmlToModal(filterTypeDropdown, title, descr, opts);

    });

    $("#filterTitle,#filterDescr,#dropdownFilterValues").on('keyup', function () {
        var filterTypeDropdown = $('#filterTypeDropdown option:selected').val();
        var title = $('#filterTitle').val();
        var descr = $('#filterDescr').val();
        var opts = $('#dropdownFilterValues').val();

        clearTimeout(timer);
        timer = setTimeout(function () {
            addFilterHtmlToModal(filterTypeDropdown, title, descr, opts);
        }, 2000); //2 seconds interval
    });

    $('#auto_update_onoff').on('switchChange.bootstrapSwitch', function (event, state) {
        toggleRefreshButton(state);

        if (state) {
            generateReport();
        }
    });

    $('body').on('click', '#refreshReport', function (event) {
        $('#refreshReport').addClass('manual');
        serializeFilters();
        generateReport();
        $('.manual').removeClass('manual');
    });

    $("#filtersModalSaveButton").click(function () {
        if ($('.edit').length) {
            editFilter($('.edit'));
        } else {
            addNewFilter();
        }

        serializeFilters();
        generateReport();
        $('#filtersModal').modal('hide');
    });

    $("#addFieldModalSaveButton").click(function () {
        var query = queryDiv.getValue();
        var field = $('#tableColumns option:selected').val();
        queryDiv.setValue(query + ' ' + field);
//        $('#queryArea').text(query + ' ' + field);

        $('#addFieldModal').modal('hide');
        generateReport();
    });

    $('body').on('hidden.bs.modal', function (e) {
        $('.edit').removeClass('edit'); //delete class on every modal hide
    });
});