$(document).ready(function () {

    var timer;
    clearTimeout(timer);

    timer = setTimeout(function () {
        $(".note").fadeOut('slow', function () {
            $(".note").hide();
        });
    }, 7000);

    $(".deleteButton").click(function () {
        var reportName = $(this).attr('data-reportname');
        $('#deleteReportModal').attr('data-reportname', reportName);
        $('#deleteReportModal').modal('show');
    });

    $('#deleteReportButton').click(function () {
        var reportName = $('#deleteReportModal').attr('data-reportname');
        JSONParser.request('deleteReport',
                {reportName: reportName},
                function (data) {
                    if (data.error) {
                        return;
                    }

                    if ($('#deleteReportModal').hasClass('goToReportList')) {
                        location.replace('addonmodules.php?module=reportgenerator&mg-page=start');
                    } else {
                        location.reload();
                    }
                });
    });

    $(".editButton").click(function () {
        var reportName = $(this).attr('data-reportname');
        $('#editReportModal').attr('data-reportname', reportName);
        $('#editReportModal').modal('show');
    });

    $('#editReportButton').click(function () {
        var reportName = $('#editReportModal').attr('data-reportname');
        JSONParser.request('editReport',
                {reportName: reportName},
                function (data) {
                    location.replace('addonmodules.php?module=reportgenerator&mg-page=createNewReport&mg-action=showCreator');
                });
    });

    $(".addNewSection").click(function () {
        $('#addNewSectionModal').modal('show');
    });

    $("#addNewSectionModalButton").click(function () {
        var reportName = $('#addNewSectionModal').data('reportname');
        var reportType = $('#chartType option:selected').val();

        JSONParser.request('addNewSection', {
            reportName: reportName,
            reportType: reportType
        },
                function (data) {
                    location.reload();
                });
    });

    $("#deleteSectionModalButton").click(function () {
        var reportName = $('#deleteSectionModal').data('reportname');
        var reportType = $('#chartType option:selected').val();

        JSONParser.request('deleteSection', {
            reportName: reportName,
            reportType: reportType
        },
                function (data) {
                    location.reload();
                });
    });

    $('.deleteSectionButton').click(function () {
        $('#deleteSectionModal').modal('show');
    });

    $('#cancelDeleteSection').click(function () {
        $('#deleteSectionModal').modal('hide');
    });

    $('#cancelDelete').click(function () {
        $('#deleteReportModal').modal('hide');
    });

    $("#cancelNewSection").click(function () {
        $('#addNewSectionModal').modal('hide');
    });

    $('#canceledit').click(function () {
        $('#editReportModal').modal('hide');
    });
});

