<?php

// ANZ eGate WHMCS Payment Gateway
// **THIS IS NOT OFFICIAL WHMCS CODE**
// September 2008, nickbrown.com.au
// Support to nick@nickbrown.com.au
// Updated April 2009

// Set the Gateway Variables
$GATEWAYMODULE = array(
	"anzegatename" => "anzegate",
	"anzegatevisiblename" => "ANZ eGate",
	"anzegatetype" => "CC",
);

function anzegate_activate() {
	defineGatewayField("anzegate","text","vpc_Merchant","","Merchant ID","20","");
	defineGatewayField("anzegate","text","vpc_AccessCode","","Merchant Access Code","20","");
}

function anzegate_link($params) {
	$code = '
<form method="post" action="'.$params["systemurl"].'/creditcard.php" name="paymentfrm">
<input type="hidden" name="invoiceid" value="'.$params['invoiceid'].'">
<input type="submit" value="'.$params['langpaynow'].'">
</form>';
	return $code;
}

function anzegate_capture($params) {

	// Gateway URL
	$vpcURL = "https://migs.mastercard.com.au/vpcdps";
	// Varibales to pass to gateway
	$postfields['vpc_Version'] = "1";
	$postfields['vpc_Command'] = "pay";
	$postfields['vpc_Merchant'] = $params['vpc_Merchant'];
	$postfields['vpc_AccessCode'] = $params['vpc_AccessCode'];
	$postfields['vpc_MerchTxnRef'] = $params['invoiceid']."/".date('ymdHis');
	$postfields['vpc_OrderInfo'] = $params['invoiceid'];
	$postfields['vpc_Amount'] = intval(round($params['amount']*100,0));
	$postfields['vpc_CardNum'] = str_replace(' ','',$params['cardnum']);
	$postfields['vpc_CardExp'] = substr($params['cardexp'],2,2).substr($params['cardexp'],0,2);
	$postfields['vpc_CardSecurityCode'] = (strlen($params['cccvv'])>strlen($params['cardissuenum']))?$params['cccvv']:$params['cardissuenum'];

	// Form the postData string
	foreach($postfields as $key => $value)
		if (strlen($value) > 0)
			$postdata[]=urlencode($key) . '=' . urlencode($value);
	$postdata=implode('&',$postdata);	
	// Post data to remote server and capture the response
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
	curl_setopt($ch, CURLOPT_TIMEOUT,20);
	curl_setopt($ch, CURLOPT_URL, $vpcURL);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
	$data=curl_exec($ch);
	// check if there was a cURL error
	if (curl_errno($ch)) {
		$data = "ErrorNumber=".curl_errno($ch)."&ErrorMessage=CURL Error ".curl_error($ch);
	}
	curl_close($ch);

	// Parse the returned variables
	$pairArray=explode("&", $data);
	foreach ($pairArray as $pair) {
		$param = explode("=", $pair);
		$results[urldecode($param[0])] = urldecode($param[1]);
	}

	// Create a debug report to store in WHMCS
	foreach($results as $key=>$value){
		$debugreport.="$key => $value\n";
	}
	
	// Check Result
	if(isset($results['vpc_TxnResponseCode']) && $results['vpc_TxnResponseCode']==0) {
		// Transaction approved
		addInvoicePayment($params['invoiceid'],$results['vpc_ReceiptNo'],$results['vpc_Amount']/100,0,"anzegate");
		logTransaction("anzegate",$debugreport,"Successful");
		sendMessage("Credit Card Payment Confirmation",$params['invoiceid']);
		$result="success";
	} else {
		// Transaction failed
		logTransaction("anzegate",$debugreport,"Declined");
		sendMessage("Credit Card Payment Failed",$params['invoiceid']);
		$result="declined";
	}

	return $result;
}
?>
