{*
 * RCM Google Suite Provisioning Module - Custom Management Dashboard Template
 *
 * @package		Resellerclub Mods (gIF)
 * @author		Resellerclub Mods contact[at]resellerclub-mods.com
 * @copyright	Copyright (c) resellerclub-mods.com 2011-2019
 * @license		http://www.resellerclub-mods.com/en/terms-of-service/eula.html
 * @link		http://www.resellerclub-mods.com/
 * @version		v4.3.2
 *}
 
<h2>{$LANG.rcmrgspm_managementtitle}</h2>

{if $rcm_status neq "Active"}
	<table class="table table-list">
		<tr>
			<td>{$LANG.rcmrgspm_statustitle}:</td>
			<td>
				<div style="color:{$rcm_status_color}">
					{if $rcm_status eq 'Suspended'}
						{$LANG.rcmrgspm_hostingsuspended}
					{elseif $rcm_status eq 'InActive'}
						{$LANG.rcmrgspm_hostingpreparing}
					{elseif $rcm_status eq 'Deleted'}
						{$LANG.rcmrgspm_hostingstatusdeleted}
					{else}
						{$LANG.rcmrgspm_hostingstatusunknown}
					{/if}
				</div>
			</td>
		</tr>
	</table>
{else}
	<table class="table table-list" style="text-align:left;">
		<tr>
			<td><strong>{$LANG.rcmrgspm_statustitle}:</strong></td>
			<td><div style="color:{$rcm_status_color};">{$LANG.rcmrgspm_hostingactive}</div></td>
		</tr>
		<tr>
			<td><strong>{$LANG.rcmrgspm_mailaccountstitle}:</strong></td>
			<td>{$rcm_mailnum} {$rcm_buymore}</td>
		</tr>
		<tr>
			<td><strong>{$LANG.rcmrgspm_createdaccstitle}:</strong></td>
			<td>{$rcm_createdaccounts}</td>
		</tr>
		<tr>
			<td><strong>{$LANG.rcmrgspm_mailacclefttitle}:</strong></td>
			<td>{$rcm_uncreatedaccounts}</td>
		</tr>
		<tr>
			<td><strong>{$LANG.rcmrgspm_controlpanelstitle}:</strong></td>
			<td>
				{if $rcm_apiresult}<br />{$rcm_apiresult}{/if}
				{if $rcm_gsuiteadminpending eq "WAITING_FOR_ADMIN_DETAILS"}
					<p><strong>{$LANG.rcmrgspm_adminaccountsetup1}</strong><br />{$LANG.rcmrgspm_adminaccountsetup2}</p>
					<form action="clientarea.php?action=productdetails&id={$rcm_domainid}" method="post">
					<div class="input-group" style="min-width:300px;">
					  <span class="input-group-addon">{$LANG.rcmrgspm_emailaliaslabel}</span>
					  <input type="text" name="gsuite-email-address" value="{$rcm_gsuiteemailalias}" class="form-control">
					  <span class="input-group-addon">@{$domain}</span>
					</div><br />

					<div class="input-group">
					  <span class="input-group-addon">{$LANG.rcmrgspm_emailpasswordlabel}</span>
					  <input type="text" name="gsuite-password" value="{$rcm_gsuiteemailpass}" class="form-control">
					</div><br />

					<div class="input-group">
					  <span class="input-group-addon">{$LANG.rcmrgspm_adminaccountfirstname}</span>
					  <input type="text" name="gsuite-first-name" value="{$rcm_gsuitefirstname}" class="form-control">
					</div><br />

					<div class="input-group">
					  <span class="input-group-addon">{$LANG.rcmrgspm_adminaccountlastname}</span>
					  <input type="text" name="gsuite-last-name" value="{$rcm_gsuitelastname}" class="form-control">
					</div><br />

					<div class="input-group">
					  <span class="input-group-addon">{$LANG.rcmrgspm_clientalternatemail}</span>
					  <input type="text" name="gsuite-alternate-email-address" value="{$rcm_gsuitealternatemail}" class="form-control">
					</div><br />

					<div class="input-group">
					  <span class="input-group-addon">{$LANG.rcmrgspm_clientname}</span>
					  <input type="text" name="gsuite-name" value="{$rcm_gsuitefullname}" class="form-control">
					</div><br />

					<div class="input-group">
					  <span class="input-group-addon">{$LANG.rcmrgspm_clientcompanyname}</span>
					  <input type="text" name="gsuite-company" value="{$rcm_gsuitecompany}" class="form-control">
					</div><br />

					<div class="input-group">
					  <span class="input-group-addon">{$LANG.rcmrgspm_clientzipcode}</span>
					  <input type="text" name="gsuite-zip" value="{$rcm_gsuitezipcode}" class="form-control">
					</div><br />

					<input type="hidden" name="gsuite-orderid" value="{$rcm_gsuiteorderid}">
					<p align="center"><input class="btn btn-success" name="setupadmin" type="submit" value="{$LANG.rcmrgspm_setupadminaccountlabel}" onclick="this.form.submit()" /></p>
					</form>
				{else}
					<div style="float:left;padding:2px;"><a class="btn btn-primary" href="/{$gsuite_url}" target="_blank">{$LANG.rcmrgspm_adminconsolebutton}</a></div>
					{if $rcm_dnsbutton}<div style="float:left;padding:2px;">{$rcm_dnsbutton}</div>{/if}
					{if $rcm_renewbutton}<div style="float:left;padding:2px;">{$rcm_renewbutton}</div>{/if}
				{/if}
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<br />
				{$rcm_nschangemessage}
				<p><strong>{$LANG.rcmrgspm_nsservertitle}:</strong></p>
			</td>
		</tr>			
		{if $rcm_hostingnstype eq '1'}
		<tr>
			<td colspan="2" style="border:none;">
				{$rcm_nsoption1}
				<div>
					<br />
					{$rcm_dns_servers}
					{if $rcm_dnssetupbutton}
						<div>{$rcm_dnssetupbutton}</div>
					{/if}
				</div>
			</td>
		</tr>
		{/if}
		<tr>
			<td colspan="2" style="border:none;">
				{$rcm_nsoption2}
				<div>
					<table>
						<tr>
							<td colspan="5">
								<p style="text-align:center"><strong>{$LANG.rcmrgspm_mxrecords}</strong></p>
							</td>
						</tr>
						{foreach from=$rcm_mx_records item=mx_record}
							<tr>
								{foreach from=$mx_record item=record}
									<td><div style="{if $record eq $domain}min-width:300px;word-wrap:break-word;{else}min-width:50px;word-wrap:break-word;{/if}">{$record}</div></td>
								{/foreach}
							</tr>
						{/foreach}
					</table>
				</div>
			</td>
		</tr>
	</table>
{/if}