<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'settings', 'sets')}</li>
</ul>

<table class="table table-hover table-striped" id="setstable">
    <thead>
        <tr>
            <th>{$MGLANG->T('table','name')}</th>
            <th>{$MGLANG->T('table','user')}</th>
            <th>{$MGLANG->T('table','dns_records')}</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>
    
<div class="well">
    <a class="btn btn-success btn-inverse" data-act="addSet">{$MGLANG->T('add_set')}</a>
</div>

{literal}
    <script data-cfasync="false" type="text/javascript">
        function refreshTable() {
            jQuery('#setstable').DataTable().ajax.reload();
        }
        
        function setSaveCallback(data, $obj) {refreshTable();}
        function removeSetCallback(data, $obj) {refreshTable();}
        
        function addNewRecordCallback(data, $obj) {
            if(!data.new_record) return false;
            $obj.parents('form').find('tr.nobody-is-here').hide();
            $obj.parents('form').first().find('.set-records table tbody').append(data.new_record);
            var $input = $obj.parents('.add-me-right-here').first().find('[name=records_counter]');
            $input.val(parseInt($input.val()) + 1);
        }
        
        function removeRecord($obj) {
            $('.mg-wrapper [title]').bstooltip('hide');
            var $tbody = $obj.parents('tbody');
            $obj.parents('tr').first().remove();
            if(!Boolean($tbody.find('tr:not(.nobody-is-here)').length)) {
                $tbody.find('tr.nobody-is-here').show();
            }
            return false;
        }
    </script>
{/literal}

{literal}
    <script data-cfasync="false" type="text/javascript">
        jQuery(document).ready(function(){
            var last;
            
            jQuery('#table-filters').change(function() {
                jQuery('#setstable').DataTable().ajax.reload();
            });
            
            jQuery('#setstable').dataTable({
                drawCallback: replaceEmptyRowDataTable,
                serverSide: true,
                //searching: true,
                searchDelay: 800,
                autoWidth: false,
                ajax: function(data, callback, settings){
                    if(last != data.length) {
                        data.start = 0;
                    }
                    last = data.length;

                    var filters = [];//$('#table-filters :input').serializeArray();
                    JSONParser.request(
                        'refreshSetsTable'
                        , $.merge(filters, [
                            {name: 'order[column]', value: data.columns[data.order[0].column].name},
                            {name: 'order[dir]', value: data.order[0].dir},
                            {name: 'limit', value: data.length},
                            {name: 'offset', value: data.start},
                            {name: 'search', value: data.search.value},
                        ])
                        , function(data) {
                            callback(data);
                            jQuery('.mg-wrapper [title]').bstooltip();
                        }
                    );
                },
                columns: [
                  {name: 'name'},
                  {name: 'idu'},                      
                  {name: 'dnsrecords'},
                  { orderable: false, targets: 0}
                ],
                pagingType: "simple_numbers",
                aLengthMenu: [
                    [5, 10, 25, 50, 75, 100],
                    [5, 10, 25, 50, 75, 100]
                ],
                iDisplayLength: 10,
                //sDom: 't<"table-bottom"<"row"<"col-sm-6"p><"col-sm-6"L>>>',
                "oLanguage": {
                    "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                    "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                    "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                    "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                    "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                    "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                    "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                    "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                    "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                 }
            });
            
        });
    </script>
{/literal}