<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li><a data-act="backups">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'export')}</a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'export')} #{$exportId}</li>
</ul>
<table class="table table-striped" id="export-list">
    <thead>
        <tr>
            <th><div class="checkbox" id="selectall"><input type="checkbox" class="select_all"/><input type="hidden" name="id" value="{$exportId}" /></div></th>
            <th>{$MGLANG->T('zone')}</th>
            <th>{$MGLANG->T('ip')}</th>
            <th>{$MGLANG->T('status')}</th>
            <th>{$MGLANG->T('client')}</th>
            <th>{$MGLANG->T('related_item')}</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        
    </tbody>
</table>

<div class="well">
    <a class="btn btn-primary btn-inverse" data-act="exportZones" data-formid="export-list" data-dt="1" data-query="id={$exportId}">{$MGLANG->T('exportZones')}</a>
</div>

{literal}
    <script data-cfasync="false" type="text/javascript">
        function exportZonesCallback(){
            var currentPage = DNSgetCurrentPageNumber();
            jQuery('#export-list').DataTable().ajax.reload();
            DNSJumpToSpecificPageNumber(currentPage);
        }        

        function createOption(object, container) {  
            return "#" + object.id + " " + object.name;
        }
        
        function createSelection(object, container) {  
            var $el = $(this.element);
            var $next = $el.next();
            
            $next.data('query', $el.data('query') + "&clientid=" + object.id);
            $next.val(object.id);
            $next.trigger('click');
            
            return "#" + object.id + " " + object.name;
        }
        
        function initSelection(element, callback) {
            callback({id: $(element).data('id'), name: $(element).data('name') });
        }
        
        function turnOnSelect2() {        
            try {
                $(".mg-wrapper .select2x").select2({
                    placeholder: "Search for a client",
                    minimumInputLength: 1,
                    containerCssClass: ' tpx-select2-container',
                    dropdownCssClass: ' tpx-select2-drop',
                    formatResult: createOption,
                    formatSelection: createSelection,
                    initSelection: initSelection,
                    ajax: {
                        url: "addonmodules.php?module=DNSManager2&mg-page=tools&mg-action=getClientsList&json=1",
                        dataType: 'json',
                        quietMillis: 250,
                        data: function (term, page) {
                            return {
                                q: term, // search term
                                page: page,
                            };
                        },
                        results: function (data, page) {
                            page = page || 1;
                            return {
                                results: data.response.items,
                                more: (page * 30) < data.response.total
                            };
                        },
                        cache: true
                    },
                });
            } catch(e) {}
        }
        
        function setRowsID(setting) {
            $('#export-list tbody tr').each( function(){
                var id = $(this).find('.row-id').data('id');
                $(this).attr('id', id);
            });
            
            try {
                $(".mg-wrapper select.select2").select2({
                    containerCssClass: ' tpx-select2-container',
                    dropdownCssClass: ' tpx-select2-drop'
                });
            } catch(e) {}

            $(".mg-wrapper .checkbox input[type='checkbox']").iCheck({
                checkboxClass: 'checkbox-styled',
                radioClass: 'radio-styled',
                increaseArea: '20%'
            });
        }
        jQuery(document).ready(function(){
            jQuery('#export-list').dataTable({
                drawCallback: function (){
                    setRowsID();
                    replaceEmptyRowDataTable();
                },
                serverSide: true,
                searchDelay: 800,
                autoWidth: false,
                ordering: false,
                ajax: function(data, callback, settings){                  
                    var filters = $('#table-filters :input').serializeArray();
                    JSONParser.request(
                        'refreshExportTable',
                        $.merge(filters, [
                            {name: 'limit', value: data.length},
                            {name: 'offset', value: data.start},
                            {name: 'search', value: data.search.value},
                            {name: 'id', value: {/literal}{$exportId}{literal}},

                        ])
                        , function(data) {
                            callback(data);
                            jQuery('.mg-wrapper [title]').bstooltip();
                            turnOnSelect2();
                            addCustomPagination('export-list', 1);
                        }
                    );
                },
                columns: [
                    { orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                    ,{ orderable: false, targets: 0}
                ],
                pagingType: "simple_numbers",
                aLengthMenu: [
                    [5, 10, 25, 50, 75, 100],
                    [5, 10, 25, 50, 75, 100]
                ],
                iDisplayLength: 10,
                "oLanguage": {
                    "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                    "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                    "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                    "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                    "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                    "sSearch": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sSearch')}{literal}",
                    "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                    "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                    "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}",
                }
            });
        });

        var table = jQuery('#export-list').DataTable();
        jQuery('#selectall').change(function(){

            jQuery('input[type="checkbox"]',table.rows().nodes()).prop('checked',$("#selectall :input")[0].checked).iCheck('update');
        });
    </script>
{/literal}

{literal}
<script type="text/javascript">
    DNSAutoselectMatches = {/literal}{if $autocheckMatches}true{else}false{/if}{literal};

    function getUserServicesCallback(data, $obj) {
        $obj.parents('tr').first().find('.services').html(data.html);
        var isSelected = $obj.parents('tr').find('.select2.services').val();
        if(isSelected && isSelected !== '0::0' && DNSAutoselectMatches){
            $obj.parents('tr').find('.sel').prop('checked', true);
        }
    }

    function importZonesCallback(data, $obj) {
        jQuery('#export-list').DataTable().ajax.reload(null, false);
    }

    (function($){
        $(document).delegate('.select2x', 'change', function() {
            $(this).parents('tr').find('.sel').prop('checked', true);
        });
        $(document).delegate('#DNSJumpToPage', 'change', function() {
            var page = jQuery('#DNSJumpToPage').val();
            if(page == 0){
                jQuery('#DNSJumpToPage').val(1);
                page = 1;
            }
            var dTableVars = jQuery('#import-list').DataTable().page.info();
            if(page > dTableVars.pages){
                jQuery('#DNSJumpToPage').val(dTableVars.pages);
                page = dTableVars.pages;
            }
            //jQuery('#import-list').DataTable().page(page-1).ajax.reload(null, false);
            DNSJumpToPage();
        });

        $('#export-list').on( 'length.dt', function(){
            DNSJumpToPage();
        });

        var jumpToPageContent = '<div class="hidden pull-right" id="DNSJumpToPageBlock" style="display:inline-block;">'
            +'<ul class="pagination">'
            +'<li id="DNSCustomPaginPrev" class="paginate_button previous disabled"><a href="#" onclick="DNSGoToPrevPage(event);">Previous</a></li>'
            +'<li class="paginate_button" id="DNSCustomPrevButton2" onclick="DNSJumpToButtonPage(this);"> <a href="#"></a></li>'
            +'<li class="paginate_button" id="DNSCustomPrevButton1" onclick="DNSJumpToButtonPage(this);"> <a href="#"></a></li>'
            +'<li class="paginate_button"><a style="padding: 0px 0px; height: 100%;"><input id="DNSJumpToPage" type="text" maxlength="5" size="4" onkeypress="return checkIfIsNumber(event);" style="width: 40px; padding: 6px 0px; text-align: center; border:none; color:#fff; background-color:#337ab7; border-color:#337ab7;"></input></a></li>'
            +'<li class="paginate_button" id="DNSCustomNextButton1" onclick="DNSJumpToButtonPage(this);"> <a href="#"></a></li>'
            +'<li class="paginate_button" id="DNSCustomNextButton2" onclick="DNSJumpToButtonPage(this);"> <a href="#"></a></li>'
            +'<li id="DNSCustomPaginNext" class="paginate_button next"><a href="#" onclick="DNSGoToNextPage(event);">Next</a></li>'
            +'</ul></div>';
        jQuery('#export-list_paginate').parent().append(jumpToPageContent);
    })(jQuery);

    function DNSJumpToPage(){
        var page = jQuery('#DNSJumpToPage').val();
        if(page == 0){
            jQuery('#DNSJumpToPage').val(1);
            page = 1;
        }
        if(page == 1){
            jQuery('#DNSCustomPaginPrev').addClass('disabled');
        }else{
            jQuery('#DNSCustomPaginPrev').removeClass('disabled');
        }
        var dTableVars = jQuery('#export-list').DataTable().page.info();
        if(page > dTableVars.pages){
            jQuery('#DNSJumpToPage').val(dTableVars.pages);
            page = dTableVars.pages;
        }
        if(page == dTableVars.pages){
            jQuery('#DNSCustomPaginNext').addClass('disabled');
        }else{
            jQuery('#DNSCustomPaginNext').removeClass('disabled');
        }
        jQuery('#export-list').DataTable().page(page-1).ajax.reload(null, false);
        DNSReloadCustomPageNumbers(page, dTableVars.pages);
    }
    function DNSGoToPrevPage(event){
        event.preventDefault();
        if(!jQuery('#DNSCustomPaginPrev').hasClass('disabled')){
            var page = jQuery('#DNSJumpToPage').val();
            jQuery('#DNSJumpToPage').val(parseInt(page) - 1);
            DNSJumpToPage();
        }
    }
    function DNSGoToNextPage(event){
        if(!jQuery('#DNSCustomPaginNext').hasClass('disabled')){
            event.preventDefault();
            var page = jQuery('#DNSJumpToPage').val();
            jQuery('#DNSJumpToPage').val(parseInt(page) + 1);
            DNSJumpToPage();
        }
    }
    function DNSReloadCustomPageNumbers(page, maxPage){
        var tempPage = parseInt(page);
        var tempMaxPage = parseInt(maxPage);
        jQuery('#DNSCustomPrevButton2').children().first().html(tempPage-2);
        jQuery('#DNSCustomPrevButton1').children().first().html(tempPage-1);
        jQuery('#DNSCustomNextButton1').children().first().html(tempPage+1);
        jQuery('#DNSCustomNextButton2').children().first().html(tempPage+2);
        if(tempPage == 1){
            jQuery('#DNSCustomPrevButton1').addClass('hidden');
            jQuery('#DNSCustomPrevButton2').addClass('hidden');
        }else if(tempPage == 2){
            jQuery('#DNSCustomPrevButton2').addClass('hidden');
            jQuery('#DNSCustomPrevButton1').removeClass('hidden');
        }else{
            jQuery('#DNSCustomPrevButton1').removeClass('hidden');
            jQuery('#DNSCustomPrevButton2').removeClass('hidden');
        }
        if(tempPage == tempMaxPage){
            jQuery('#DNSCustomNextButton1').addClass('hidden');
            jQuery('#DNSCustomNextButton2').addClass('hidden');
        }else if(tempPage == tempMaxPage -1){
            jQuery('#DNSCustomNextButton2').addClass('hidden');
            jQuery('#DNSCustomNextButton1').removeClass('hidden');
        }else{
            jQuery('#DNSCustomNextButton1').removeClass('hidden');
            jQuery('#DNSCustomNextButton2').removeClass('hidden');
        }
    }

    function DNSJumpToButtonPage(item){
        var id = jQuery(item).prop('id');
        var curPage = jQuery('#DNSJumpToPage').val();
        if(id.indexOf('Next') == 9)
        {
            var pageNr = id.replace('DNSCustomNextButton', '');
            jQuery('#DNSJumpToPage').val(parseInt(curPage) + parseInt(pageNr));
        }
        if(id.indexOf('Prev') == 9)
        {
            var pageNr = id.replace('DNSCustomPrevButton', '');
            jQuery('#DNSJumpToPage').val(parseInt(curPage) - parseInt(pageNr));
        }
        DNSJumpToPage();
    }
</script>
{/literal}
