<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'import')}</li>
</ul>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="panel-title">{$MGLANG->T('import')}</h3>
    </div>
    <div class="panel-body">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>{$MGLANG->T('import')}</th>
                    <th>{$MGLANG->T('zones_imported_total')}</th>
                    <th>{$MGLANG->T('progress')}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$imports item="import"}
                    <tr>
                        <td>{$import.parsedDesc.0}<b>{$import.parsedDesc.1}</b>{$import.parsedDesc.2}<b>{$import.parsedDesc.3}</b></td>
                        <td>{$import.zones_imported}/{$import.zones_total}</td>
                        <td>
                            {if $import.error neq false}
                                {$import.error}
                            {elseif $import.progress < 0}
                                {$MGLANG->T('fetching_list')}
                            {else}
                            <div class="progress" style="margin-bottom: 0px;">
                                <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="{$import.progress}" aria-valuemin="0" aria-valuemax="100" style="width: {$import.progress}%;">{$import.progress}%</div>
                            </div>
                            {/if}
                        </td>
                        <td>
                        {if $import.progress >= 0 && $import.error eq false}
                            <a class="btn btn-primary btn-inverse btn-icon-only" data-act="{if $import.type === 'importToFIle'}showListImportToFile{else}showListImport{/if}" data-query="id={$import.id}" title="{$MGLANG->T('show_list')}"><i class="fa fa-edit"></i></a>
                        {/if}
                            <a class="btn btn-primary btn-inverse btn-icon-only" data-act="scheduleImport" data-query="id={$import.id}" data-confirm-body="{$MGLANG->T('schedule_import_confirmation')}" title="{$MGLANG->T('schedule_import')}"><i class="fa fa-play"></i></a>
                            <a class="btn btn-danger btn-inverse btn-icon-only" data-act="removeImport" data-confirm-body="{$MGLANG->T('remove_import_confirmation')}" data-query="id={$import.id}" title="{$MGLANG->T('cancel')}"><i class="fa fa-remove"></i></a>
                        </td>
                    </tr>
                {foreachelse}
                    <tr><td colspan="4" align="center">{$MGLANG->T('there_are_no_import')}</td></tr>
                {/foreach}
            </tbody>
        </table>
        <div class="well well-sm">
            <a class="btn btn-success btn-inverse" data-act="addImport">{$MGLANG->T('add_import')}</a>
        </div>
    </div>
</div>