<ul class="breadcrumb">
    <li><a href="addonmodules.php?module=DNSManager2"><i class="fa fa-home"></i></a></li>
    <li class="active">{$MGLANG->absoluteT('addonAA', 'pagesLabels', 'tools', 'migration')}</li>
</ul>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="panel-title">{$MGLANG->T('migration')}</h3>
    </div>
    <div class="panel-body">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>{$MGLANG->T('migration')}</th>
                    <th>{$MGLANG->T('zones_moved_total')}</th>
                    <th>{$MGLANG->T('progress')}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$migrations item="migration"}
                    <tr>
                        <td>{$migration.desc}</td>
                        <td>{$migration.zones_moved}/{$migration.zones_total}</td>
                        <td>
                            {if $migration.error neq false}
                                {$migration.error}
                            {elseif $migration.progress < 0}
                                {$MGLANG->T('fetching_list')}
                            {else}
                                <div class="progress" style="margin-bottom: 0px;">
                                    <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="{$migration.progress}" aria-valuemin="0" aria-valuemax="100" style="width: {$migration.progress}%;">{$migration.progress}%</div>
                                </div>
                            {/if}
                        </td>
                        <td>
                            {if $migration.progress >= 0 && $migration.error eq false}
                                <a class="btn btn-primary btn-inverse btn-icon-only" data-act="showListMigration" data-query="id={$migration.id}" title="{$MGLANG->T('show_list')}"><i class="fa fa-edit"></i></a>
                            {/if}
                            <a class="btn btn-primary btn-inverse btn-icon-only" data-act="scheduleMigration" data-query="id={$migration.id}" data-confirm-body="{$MGLANG->T('schedule_migration_confirmation')}" title="{$MGLANG->T('schedule_migration')}"><i class="fa fa-play"></i></a>
                            <a class="btn btn-danger btn-inverse btn-icon-only" data-act="removeMigration" data-confirm-body="{$MGLANG->T('remove_migration_confirmation')}" data-query="id={$migration.id}" title="{$MGLANG->T('cancel')}"><i class="fa fa-remove"></i></a>
                        </td>
                    </tr>
                {foreachelse}
                    <tr><td colspan="4" align="center">{$MGLANG->T('there_are_no_migration')}</td></tr>
                {/foreach}

            </tbody>
        </table>
        <div class="well well-sm">
            <a class="btn btn-success btn-inverse" data-act="addMigration">{$MGLANG->T('add_migration')}</a>
        </div>
    </div>
</div>