<div class="modal modal-lg" id="edit-set-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">{$MGLANG->T('close')}</span></button>
                <h4 class="modal-title">{$MGLANG->T('edit_zone')} <small>{$zone_name}</small></h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal">
                    <input type="hidden" name="id" value="{$id}" />
                    <div class="row zone-records">
                        <div class="col-md-12">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th {if $ttl_disabled}style="display: none;"{/if}></th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {foreach from=$records item="record"}
                                        <tr id="record{$counter}">
                                            <td class="form-group"><input class="form-control" type="text" name="record[{$counter}][name]" value="{$record->nameToAbsolute($zone_name)}" title="{$MGLANG->T('record_info','name')}" placeholder="{$MGLANG->T('name')}" required=""/></td>
                                            <td style="max-width: 100px"><input type="hidden" name="record[{$counter}][type]" value="{$record->type}"/><input class="form-control" type="text" value="{$record->type}" disabled="" title="{$MGLANG->T('record_type_info', $record->type)}"/></td>
                                            <td class="form-group" style="max-width: 140px;{if $ttl_disabled} display: none;{/if}"><input class="form-control" type="number" name="record[{$counter}][ttl]" value="{$record->ttl}" title="{$MGLANG->T('record_info','ttl')}" placeholder="{$MGLANG->T('ttl')}" required="" min="1"/></td>
                                            <td>
                                                {foreach from=$record->rdata key="field" item="value"}
                                                    <input class="form-control table-input" type="text" name="record[{$counter}][field][{$field}]" value="{$value}" title="{$MGLANG->T('record_field_info',$record->type, $field)}" placeholder="{$field}"/>
                                                {/foreach}
                                            </td>
                                            <td class="action-cell">
                                                <input name="record[{$counter}][line]" type="hidden" value="{$record->line}" />
                                                <a class="btn btn-danger btn-inverse" data-act="removeZoneRecord" data-formid="record{$counter}" data-query="id={$id}" data-do-not-close-the-modal="" title="{$MGLANG->T('remove_record')}" data-confirm-body="{$MGLANG->T('remove_zone_record_confirm')}"><span class="glyphicon glyphicon-remove"></span></a>
                                            </td>
                                        </tr>
                                        {assign var="counter" value=$counter+1}
                                    {foreachelse}
                                        <tr>
                                            <td id="no-records" colspan="4">{$MGLANG->T('there_is_no_supported_record_within_this_zone')}</td>
                                        </tr>
                                    {/foreach}
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row new-record-select">
                        <div class="col-md-4"></div>
                        <div class="col-md-4"></div>
                        <div class="col-md-4">
                            <div class="row">
                                <div class="col-md-9 col-xs-6">
                                    <input type="hidden" name="records_counter" value="{$counter + 1}" />
                                    <input type="hidden" name="ttl_disabled" value="{if $ttl_disabled}1{else}0{/if}" />
                                    <select class="select2" name="new_record_type">
                                    {foreach from=$available_record_types item="record"}
                                        <option value="{$record}">{$record}</option>
                                    {/foreach}
                                    </select>
                                </div>
                                <div class="col-md-3 col-xs-3">
                                    <a class="btn btn-success btn-inverse" data-act="addNewRecord" data-do-not-close-the-modal="" data-no-validate="1" title="{$MGLANG->T('add_new_record')}">
                                        <span class="glyphicon glyphicon-arrow-right"></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row new-record" id="new-record">
                        <div class="col-md-12">
                            <table class="table table-striped">
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('close')}</button>
                <button type="button" class="btn btn-primary btn-inverse" data-act="editZoneSave">{$MGLANG->T('save_changes')}</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->  
