<div class="modal" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="true" id="removeZoneModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <form class="form-horizontal" action="" method="post" id="zone_form">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">{$MGLANG->T('close')}</span></button>
                    <h4 class="modal-title">{$MGLANG->T('mass_remove_for_whmcs_records')}</h4>
                </div>
                <div class="modal-body">
                    <div id="massRemoveConfiramtionMessage">
                        {$MGLANG->T('mass_remove_records_for_whmcs_confirm_message')}
                    </div>
                    <div id="massRemoveProgressBar" class="progress progress-striped active hidden">
                        <div id="MGProgressBarStatus" class="progress-bar progress-bar-danger"></div>
                    </div>
                    <div id="massRemoveActionErrors">
                        <ul>

                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default btn-inverse" id="closeRemoveModal" data-dismiss="modal" data-secondname="{$MGLANG->T('close')}">{$MGLANG->T('cancel')}</button>   
                    <button class="btn btn-danger btn-inverse" type="button" id="removeSelectedRecords">{$MGLANG->T('mass_remove_records')}</button>
                </div>
            </form>
        </div>
    </div>
</div>

{literal}
    <script data-cfasync="false" type="text/javascript">
        var $ = jQuery;
        var toRemoved = {/literal}{$sets}{literal};
        var refresh = false;
        function disabledButtons(){
            $('#removeSelectedRecords').addClass('disabled');
            $('#closeRemoveModal').addClass('disabled');
        }
        
        function changeCloseButton(){
            $('#closeRemoveModal').removeClass('disabled');
            $('#closeRemoveModal').text($('#closeRemoveModal').data('secondname'));
        }
        function toogleBoxInformation() {
            $('#massRemoveActionErrors ul').text(' ');
            $('#massRemoveConfiramtionMessage').addClass('hidden');
            $('#massRemoveProgressBar').removeClass('hidden');
            $('#MGRemoveModalButtons').addClass('hidden');
            updateProgress(0);
        }

        function calculateProgress(complete, max) {
            var sum = complete / max * 100;
            var rounded = Math.round(sum);
            updateProgress(rounded)
        }
        function addMessage(type, id, message) {
            $('#massRemoveActionErrors ul').append('<li>' + type + ': #' + id + ' ' + message + '</li>');
        }

        function updateProgress(percent) {
            $('#MGProgressBarStatus').css('width', percent + '%');
            $('#MGProgressBarStatus').text(percent + '%');
            if (percent == 100) {
                $('#massRemoveProgressBar').removeClass('active');
            }
        }
        $('#removeSelectedRecords').on('click', function () {
            toogleBoxInformation();
            disabledButtons();
            var i = 1;
            $.each(toRemoved, function (index, value) {
                JSONParser.request('removeZoneFromWHMCS', [{name: 'id', value: value}], function (data) {
                    calculateProgress(i++, toRemoved.length);
                    if (data.infos.length > 0) {
                        addMessage('Success', value, data.infos[0]);
                        refresh = true;
                    }
                    if (data.errors.length > 0) {
                        addMessage('Error', value, data.errors[0]);
                    }
                    if (data.warnings.length > 0) {
                        addMessage('Warnings', value, data.warnings[0]);
                    }
                    if(i > toRemoved.length){
                        changeCloseButton();
                    }
                }, false);
            });
        });
        $('#removeZoneModal').on('hidden.bs.modal', function () {
            if(refresh === true){
                $('#zonelist').DataTable().ajax.reload();
            }
        });

    </script>
{/literal}