<div class="modal" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form class="form-horizontal" action="" method="post" id="zone_form">
                <input type="hidden" name="dnsaction" value="createzone" />  
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">{$MGLANG->T('add_dns_zone')}</h4>
                </div>
                <div class="modal-body">
                    <div id="create_zone_area">
                        <input type="hidden" name="type" value="{$type}" />
                        <input type="hidden" name="relid" value="{$relid}" />
                        <div class="form-group"> 
                            <label class="control-label col-sm-3">{$MGLANG->T('zone_name')}</label>
                            <div class="col-sm-7">
                                <input class="form-control" type="text" name="zone_name" value="" required pattern="(.*\.)+.+" {*pattern="{literal}^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}{/literal}"*}/>
                            </div>
                        </div>
                        {if $custom_ip}
                            <div class="form-group"> 
                                <label class="control-label col-sm-3">{$MGLANG->T('ip')}</label>
                                <div class="col-sm-7">
                                    <input class="form-control" type="text" name="zone_ip" value="" required pattern="{$patterns.ip}"/>
                                </div>
                            </div>
                        {else}
                            <div class="form-group">
                                <label class="control-label col-sm-3">{if $ipmanager}{$MGLANG->T('ip_or_block')}{else}{$MGLANG->T('ip')}{/if}</label>
                                <div class="col-sm-7">
                                    <select class="select2" name="zone_ip">
                                        {if $ipmanager}
                                            {foreach from=$pools item="pool"}
                                                <option value="block|{$pool.pool}|{$pool.mask}" data-pool>{$pool.pool}/{$pool.mask}</option>
                                            {/foreach}
                                        {/if}
                                        {foreach from=$ips item="ip"}
                                            <option value="{$ip}">{$ip}</option>
                                        {/foreach}
                                            <option value="">{$MGLANG->T('default_ip')}</option>
                                    </select> 
                                </div>
                            </div>

                            <div class="form-group block-ip" {if count($pools) eq 0}style="display: none"{/if}> 
                                <label class="control-label col-sm-3">{$MGLANG->T('ip')}</label>
                                <div class="col-sm-7">
                                    <input class="form-control" type="text" name="zone_ip_from_block" value="" required pattern="{$patterns.ip}"/>
                                </div>
                            </div>
                        {/if}
                        {if $allowManageRecordsSets === 'on'}
                            <div class="form-group">
                                <label class="control-label col-sm-3">{$MGLANG->T('selectRecordSet')}</label>
                                <div class="col-sm-7">
                                    <select class="select2" name="recordSet">
                                        <option value="none"  >{$MGLANG->T('none')}</option>
                                        {foreach from=$recordSets item="set"}
                                            <option value="{$set->id}">{$set->name}</option>
                                        {/foreach}
                                        {foreach from=$adminSets item="aset"}
                                            <option value="{$aset->id}">{$aset->name}</option>
                                        {/foreach}
                                            <option value="" selected >{$MGLANG->T('defaultSet')}</option>
                                    </select> 
                                </div>
                            </div>                            
                        {/if}
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('cancel')}</button>
                    <button type="button" class="btn btn-success" data-act="addZoneSave">{$MGLANG->T('add_zone')}</button>                                  
                </div>
            </form>
        </div>
    </div>
</div>
                
{literal}
    <script data-cfasync="false" type="text/javascript">
        (function($) {
            $('[name=zone_ip]').change(function() {
                $(this).parents('form').first().find('.block-ip').removeClass('has-error').toggle(typeof $('option:selected', this).data('pool') != 'undefined');
            });
        })(jQuery);
    </script>
{/literal}