<?php
/**
 * @package         Dunamis
 * @version         1.4.4
 *
 * @author          Go Higher Information Services, LLC
 * @link            https://www.gohigheris.com
 * @copyright       2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license         GNU General Public License version 2, or later
 */

defined('DUNAMIS') OR exit('No direct script access allowed');

/**
 * Dunamis Database class for Blesta
 * @desc		This is the database handler for the Dunamis Framework
 * @package		Dunamis
 * @subpackage	Blesta
 * @author		Go Higher Information Services, LLC
 * @link		https://www.gohigheris.com
 * @copyright	2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license		GNU General Public License version 2, or later
 */
class BlestaDunDatabase extends DunDatabase
{
	/**
	 * Constructor Method
	 * @access		public
	 * @version		1.4.4
	 * @param		array		- $options: contains an array of arguments
	 * 
	 * @since		1.3.0
	 */
	public function __construct( $options = array() )
	{
		$dbvals	=	(object) \Configure :: get ( 'Blesta.database_info' );
		
		// Setup the options array
		$options['hostname']	=	$dbvals->host;
		$options['username']	=	$dbvals->user;
		$options['password']	=	$dbvals->pass;
		$options['database']	=	$dbvals->database;
		
		// Construct the object
		parent :: __construct( $options );
	}
	
	
	/**
	 * Given a filename and extension and type parse and execute commands
	 * @access		public
	 * @version		1.4.4
	 * @param		string		- $filename: the relative path and filename
	 * @param		string		- $extension: the extension name
	 * 
	 * @return		boolean
	 * @since		1.3.0
	 */
	public function handleFile( $filename, $extension = null )
	{
		$path	= BlestaDunModule :: locateModule( $extension ) . $filename;
		
		if (! file_exists( $path ) ) return false;
		
		$commands = $this->parseFile( $path );
		
		foreach ( $commands as $sql ) {
			$this->setQuery( $sql );
			$this->query();
		}
		
		return true;
	}
}