<?php
/**
 * Dunamis Framework
 *
 * @package         Dunamis
 * @version         1.4.4
 *
 * @author          Go Higher Information Services, LLC
 * @link            https://www.gohigheris.com
 * @copyright       2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license         GNU General Public License version 2, or later
 */

defined('DUNAMIS') OR exit('No direct script access allowed');

/**
 * Dunamis Input Handler
 * @desc		This is the input handler for the Dunamis Framework Plugin
 * @package		Dunamis
 * @subpackage	Blesta
 * @author		Go Higher Information Services, LLC
 * @link		https://www.gohigheris.com
 * @copyright	2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license		GNU General Public License version 2, or later
 */
class BlestaDunInput extends DunInput
{
	/**
	 * Constructor method
	 * @access		public
	 * @version		1.4.4
	 * @param		array		- $options: contains an array of arguments
	 *
	 * @since		1.3.0
	 */
	public function __construct( $options = array() )
	{
		parent :: __construct( $options );
		$this->load();
	}
	
	
	/**
	 * Method to load the input into the object
	 * @access		protected
	 * @version		1.4.4
	 * @param		array		- $data: if overloaded can be passed data
	 * 
	 * @since		1.3.0
	 */
	protected function load( $data = array() )
	{
		$get		= $post = $request = array();
		
		$get		= $GLOBALS['_GET'];
		$post		= $GLOBALS['_POST'];
		$request	= $GLOBALS['_REQUEST'];
		$server		=	$GLOBALS['_SERVER'];
		
		$data	= array_merge( array( 'get' => $get, 'post' => $post, 'request' => $request, 'server' => $server ), $data );
		
		parent :: load( $data );
	}
}
