<?php
/**
 * @package         Dunamis
 * @version         1.4.4
 *
 * @author          Go Higher Information Services, LLC
 * @link            https://www.gohigheris.com
 * @copyright       2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license         GNU General Public License version 2, or later
 */

defined('DUNAMIS') OR exit('No direct script access allowed');

/**
 * Information Field
 * @desc		This is used to render HTML within a form in the Dunamis Framework
 * @package		Dunamis
 * @subpackage	WHMCS
 * @author		Go Higher Information Services, LLC
 * @link		https://www.gohigheris.com
 * @copyright	2009 - 2015 Go Higher Information Services.  All rights reserved.
 * @license		GNU General Public License version 2, or later
*/
class WhmcsInformationDunFields extends DunFields
{
	/**
	 * Stores the value to render back
	 * @access		protected
	 * @var			array
	 * @since		1.0.10
	 */
	protected $value	= array();
	
	
	/**
	 * Constructor method
	 * @access		public
	 * @version		1.4.4 ( $id$ )
	 * @param		array		- $settings: settings to pass along
	 *
	 * @since		1.0.10
	 */
	public function __construct( $settings = array() )
	{
		foreach( array( 'value' ) as $item ) {
			if ( array_key_exists( $item, $settings ) ) {
				$this->$item = (array) $settings[$item];
				unset( $settings[$item] );
			}
		}
		
		parent :: __construct( $settings );
	}
	
	
	/**
	 * Renders a form field
	 * @access		public
	 * @version		1.4.4
	 * @param		array		- $options: any options to pass along
	 * 
	 * @return		string containing form field
	 * @since		1.0.10
	 */
	public function field( $options = array() )
	{
		$values	= (array) $this->value;
		$data	= '<div style="padding-top: 7px; ">' . implode( "\n", $values ) . '</div>';
		return $data;
		foreach ( $values as $row ) {
			$data	.= '<div>' . $row . '</div>';
		}
		
		return $data . '</div>';
	}
}