
<div class="module-main-header">
    <a href="index.php?m=DNSManager2" class="btn btn-back btn-icon" style="height: inherit;"><i class="fa fa-arrow-left"></i></a><h2>{$MGLANG->T('dns_manager')}</h2>
</div>
<h3 class="myheader-title backupsHeader"></h3>
<div class="module-content">
    <div class="module-header">
        <h3 class="pull-left mg-backup-task-header">{$MGLANG->T('backups_tasks')}</h3>
        <div class="header-search">
            <div class="row-fluid-xs">
                <div class="fluid-0">
                    <a {if !$caCanAddBackup}style="display: none"{/if} class="btn btn-primary pull-right caHeaderButtonBackup" data-act="addBackupImportZones"
                       data-formid="zonesList">{$MGLANG->T('addExportToFile')}</a>
                </div>
            </div>
        </div>
    </div>
    <div class="module-body">

        <div class="section">
            <table class="table mg-ca-backup-table">
                <thead>
                <tr>
                    <th>{$MGLANG->T('taskDescription')}</th>
                    <th>{$MGLANG->T('zones_procesed_total')}</th>
                    <th>{$MGLANG->T('progress')}</th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                {foreach from=$backupsTasks item="backupTask"}
                    <tr>
                        <td>{$backupTask.parsedDesc.0}
                            <b>{$backupTask.parsedDesc.1}</b>{if $backupTask.parsedDesc.2}{$backupTask.parsedDesc.2}
                            <b>{$backupTask.parsedDesc.3}</b>{/if}</td>
                        <td>{$backupTask.zones_imported}/{$backupTask.zones_total}</td>
                        <td>
                            {if $backupTask.error neq false}
                                {$backupTask.error}
                            {elseif $backupTask.progress < 0}
                                {$MGLANG->T('waitingToSelectZones')}
                            {else}
                                <div class="progress" style="margin-bottom: 0px;">
                                    <div class="progress-bar progress-bar-success" role="progressbar"
                                         aria-valuenow="{$backupTask.progress}" aria-valuemin="0" aria-valuemax="100"
                                         style="width: {$backupTask.progress}%;">{$backupTask.progress}%
                                    </div>
                                </div>
                            {/if}
                        </td>
                        <td>
                            <a class="btn btn-primary btn-inverse btn-icon-only backups-action-button"
                               data-act="{if $backupTask.type eq 'importToFileWHMCS'}showListImportToFile{else}exportFromFile{/if}"
                               data-query="id={$backupTask.id}" title="{$MGLANG->T('show_list')}"><i class="fa fa-edit"></i></a>
                            <a class="btn btn-danger btn-inverse btn-icon-only backups-action-button" data-act="backupRemoveTask"
                               data-confirm-body="{if $backupTask.type === 'importToFileWHMCS'}{$MGLANG->T('removeBackupConfirmation')}{else}{$MGLANG->T('removeExportConfirmation')}{/if}"
                               data-query="id={$backupTask.id}&file={$backupTask.parsedDesc.1}"
                               title="{$MGLANG->T('cancel')}"><i class="fa fa-remove"></i></a>
                        </td>
                    </tr>
                    {foreachelse}
                    <tr>
                        <td colspan="4" align="center">{$MGLANG->T('there_are_no_backup_tasks')}</td>
                    </tr>
                {/foreach}
                </tbody>
            </table>
        </div>
    </div>
</div>



<div class="module-main-header"></div> <!-- HERE IS SPACE -->
<div class="module-content">
    <table class="table mg-ca-backup-table" style="width:100%" id="backupsList">
        <thead>
        <tr>
            <th>{$MGLANG->T('fileName')}</th>
            <th>{$MGLANG->T('amountOfZonesInFile')}</th>
            <th class="action-cell"></th>
        </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>




{literal}
<script type="text/javascript">
    jQuery(document).ready(function () {

        function dnsLoadButon() {

            if (!document.getElementById('addBackupFile')) {
                jQuery('#backupsList_filter').children().last().after('<a {/literal}{if !$caCanAddBackup}style="display: none"{/if}{literal} class="btn btn-primary" id="addBackupFile" style="" data-act="addBackupFile">{/literal}{$MGLANG->T('uploadFile')}{literal}</a>');
                $($('#backupsList_filter').find('input')).attr("placeholder", "{/literal}{$MGLANG->T('search')}{literal}");
            }
        }

        function dnsLoadHeader() {
            if (!document.getElementById('pageheader')) {
                jQuery('#backupsList_filter').parent().append('<div id="pageheader" class=""><div class="myheader-title"><h1 class="mg-backuplist-header">{/literal}{$MGLANG->T('backupsList')} {$backupLimitDisplay}{literal}</h1></div>');
            }
        }

        var last;

        jQuery('#table-filters').change(function () {
            jQuery('#backupsList').DataTable().ajax.reload();
        });

        jQuery('#backupsList').dataTable({
            // drawCallback: replaceEmptyRowDataTable,

            "columnDefs": [
                {"className": "dt-center", "targets": [2]}
            ],

            serverSide: true,
            searchDelay: 800,
            autoWidth: false,
            ajax: function (data, callback, settings) {
                if (last != data.length) {
                    last = data.length;
                    data.start = 0;
                    jQuery('#backupsList').DataTable().page(0);
                }
                last = data.length;

                var filters = $('#table-filters :input').serializeArray();
                JSONParser.request(
                    'refreshBackupsTable'
                    , $.merge(filters, [
                        {name: 'order[column]', value: data.columns[data.order[0].column].name},
                        {name: 'order[dir]', value: data.order[0].dir},
                        {name: 'limit', value: data.length},
                        {name: 'offset', value: data.start},
                        {name: 'search', value: data.search.value},
                    ])
                    , function (data) {
                        callback(data);
                        jQuery('.mg-wrapper [title]').bstooltip();
                        dnsLoadButon();
                        dnsLoadHeader();
                        // addCustomPagination('backupsList');
                    }
                );
            },
            columns: [
                {name: 'name'},
                {orderable: false, name: 'type'},
                {orderable: false, targets: 0, name: 'actions'}
            ],
            // order: [[0, "desc"]],
            pagingType: "simple_numbers",
            aLengthMenu: [
                [5, 10, 25, 50, 75, 100],
                [5, 10, 25, 50, 75, 100]
            ],
            dom: '<"top"f>rt<"bottom"pl><"clear">',
            iDisplayLength: 10,
            "oLanguage": {
                "sEmptyTable": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sEmptyTable')}{literal}",
                "sPrevious": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sPrevious')}{literal}",
                "sNext": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sNext')}{literal}",
                "sZeroRecords": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sZeroRecords')}{literal}",
                "sInfoEmpty": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoEmpty')}{literal}",
                "sSearch": "",
                "sLengthMenu": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sLengthMenu')}{literal}",
                "sInfoFiltered": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfoFiltered')}{literal}",
                "sInfo": "{/literal}{$MGLANG->absoluteT('addonAA','datatables','sInfo')}{literal}"
            }
        });
    });

    // $('.dataTables_length').parent().addClass('col-xs-6');
    // $('.dataTables_filter').parent().addClass('col-xs-6');



    jQuery('#selectAllZone').change(function () {
        jQuery('td input:checkbox', '#zonesList').prop('checked', true);
    });

</script>
{/literal}
        
