<script src="{$assetsURL}/js/showCreatorExpert.js" type="text/javascript"></script>
<script src="{$libURL}/ace/src-noconflict/ace.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="https://www.google.com/jsapi"></script>

<div id="mg-error-container" hidden="" class="span12 mg-error-container">
    <div class="alert alert-danger" role="alert">
        <button type="button" class="close" data-dismiss="alert">
            <span aria-hidden="true">×</span>
            <span class="sr-only"></span>
        </button>
        <p id="text"></p>
    </div>
</div>
{*<div class="col-sm-12">*}
<div class="col-md-6">
    {* ***************QUERY *************** *}
    <div class="panel panel-primary">
        <div class="panel-heading" data-toggle="collapse">
            <h4 class="panel-title">
                {$MGLANG->T('group', 'query_title')}
            </h4>
        </div>
        <div class="panel-body">
            <div id="queryDiv" style="min-height: 180px;">SELECT
                firstname AS 'Firstname',
                lastname AS 'Lastname',
                email AS 'Email'
                FROM tblclients         
                LIMIT 50;</div>
        </div>
    </div>

    {* *************** FILTERS *************** *}
    <div class="panel panel-primary">
        <div class="panel-heading ">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="panel-title padFix">
                        <span href="#" data-toggle="tooltip" title="{$MGLANG->T('tooltip', 'filters')}">
                            {$MGLANG->T('group', 'filters')}
                        </span>
                    </h4>
                </div>
                <div class="col-sm-6">
                    <button id="addFilter" type="button" class="btn btn btn-success pull-right">
                        <span class="glyphicon glyphicon-plus"></span>{$MGLANG->T('button', 'add_new_filter')}
                    </button>
                </div>
            </div>
        </div>
        <div class="panel-body">
            <div id="filterDiv" class="well well-sm" style="min-height: 70px;"></div>
        </div>
    </div>
</div>

{*  *************************Generated Chart*************************  *}
<div class="col-md-6">
    <div class="panel panel-primary">
        <div class="panel-heading ">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="panel-title padFix">{$MGLANG->T('group', 'list_of_db_tables')} </h3>
                </div>
                <div class="col-sm-6">
                    <input id="searchTables" type="text" class="form-control" placeholder="{$MGLANG->T('label', 'search_tables')}">
                </div>
            </div>
        </div>
        <div id="tables" class="panel-collapse" role="tabpanel" aria-labelledby="heading-">
            <div id="tablesDiv" class="panel-body fbox" style="overflow-y: scroll; max-height: 500px;">
                <div class="well well-sm">
                    <div class="ui-widget-content contType">{$MGLANG->T('label', 'whmcs_tables')}</div>

                    {foreach from=$dbTables.whmcs item=table key=tableName}
                        <div id="{$tableName}" class="ui-widget-content draggable {if $table.used}used{/if}">
                            {$tableName}
                        </div>
                    {/foreach}
                </div>
                <div class="well well-sm">
                    <div class="ui-widget-content contType">{$MGLANG->T('label', 'other_tables')}</div>

                    {foreach from=$dbTables.other item=table key=tableName}
                        <div id="{$tableName}" class="ui-widget-content draggable {if $table.used}used{/if}">
                            {$tableName}
                        </div>
                    {/foreach}
                </div>
            </div>
        </div>
    </div>
</div> 

<div class="col-sm-12">
    {* ***************Title and description*************** *}
    <div class="panel panel-primary">
        <div class="panel-heading" data-toggle="collapse">
            <h4 class="panel-title">
                {$MGLANG->T('group', 'section_configuration')}
            </h4>
        </div>
        <div class="panel-body">
            <div class="form-horizontal">
                <div class="form-group" >
                    <label class="col-sm-2 control-label">{$MGLANG->T('label', 'chart_title')}</label>
                    <div class="col-sm-4">
                        <input style=" width: 100%;" type="text" id="title" class="form-control">
                    </div>
                </div> 
                <div class="form-group">
                    <label class="col-sm-2 control-label">{$MGLANG->T('label', 'chart_descr')}</label>
                    <div class="col-sm-10">
                        <input style="width: 100%;" type="text" class="form-control" id="chartDescr">
                    </div>
                </div>

                <div class="form-group">
                    <label for="auto_update_onoff" class="col-sm-2 control-label">{$MGLANG->T('label', 'auto_update')}</label>
                    <div class="col-sm-10">
                        <input id="auto_update_onoff" type="checkbox" name="my-checkbox" checked>
                        <button id="refreshReport" type="button" class="btn btn btn-primary">
                            <span class="glyphicon glyphicon-refresh"></span>&nbsp;
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="col-sm-6">
    {*  ************************* RESULTS *************************  *} 
    <div class="panel panel-primary">
        <div class="panel-heading" style="cursor: pointer;" data-toggle="collapse">
            <h4 class="panel-title">
                <span href="#" data-toggle="tooltip" title="{$MGLANG->T('tooltip', 'data_generated_from_query')}">
                    {$MGLANG->T('group', 'data_generated_from_query')}
                </span>
            </h4>
        </div>
        <div class="panel-body" style="max-height: 500px;">
            <div id="tables" style="max-width: 100%;" class="panel-collapse" role="tabpanel" aria-labelledby="heading-">
                <textarea style="min-height: 100px; max-width: 100%; min-width: 100%;" rows="6" cols="95" id='results' disabled="disabled">{$results}</textarea> 
            </div>
        </div>
    </div>
</div>
<div class="col-sm-6">
    {*  ************************* PHP *************************  *}
    <div class="panel panel-primary">
        <div class="panel-heading" style="cursor: pointer;" data-toggle="collapse">
            <h4 class="panel-title">
                <span href="#" data-toggle="tooltip" title="{$MGLANG->T('tooltip', 'parse_data_with_php')}">
                    {$MGLANG->T('group', 'parse_your_data')}
                </span>
            </h4>
        </div>
        <div id="tables" class="panel-collapse" role="tabpanel" aria-labelledby="heading-">
            <div class="panel-body" style="max-height: 500px;">
                <div id="phpDiv">foreach($records as &$record){
                    $record["Firstname"] = strtoupper($record["Firstname"]);
                    }</div>
                <div>
                    <input type="checkbox" name="usePHP" id="usePHP" value="true" {if $usePHP == 'true'}checked=""{/if}> {$MGLANG->T('label', 'use_php')}<br>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="report"></div>

<div id="addFieldModal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button style="margin-top: 0px;" type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">{$MGLANG->T('modal', 'filters_modal_title')}</h4>
            </div>
            <div class="modal-body form-horizontal">
                <div class="form-group">
                    <label class="col-sm-3 control-label">{$MGLANG->T('label', 'select_column')}</label>
                    <div id="containerField" class="col-sm-9">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary" data-modal-action="save" id="addFieldModalSaveButton">{$MGLANG->T('button','save')}</button>
            </div>
        </div>
    </div>
</div>

<!--Filters Modal content-->
<div id="filtersModal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button style="margin-top: 0px;" type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">{$MGLANG->T('modal', 'filters_modal_title')}</h4>
            </div>
            <div class="modal-body">
                <div class="form-horizontal">
                    <div class="form-group">
                        <label class="col-sm-3 control-label">{$MGLANG->T('label', 'filter_type')}</label>
                        <div id="filterDivDropdown" class="col-sm-9">
                            <select id="filterTypeDropdown" class="form-control">
                                <option value="DateRangeFilter">{$MGLANG->T('label', 'data_range_filter')}</option>
                                <option value="DropdownFilter">{$MGLANG->T('label', 'dropdown_filter')}</option>
                                <option value="IntRangeFilter">{$MGLANG->T('label', 'int_range_filter')}</option>
                                <option value="TextFilter">{$MGLANG->T('label', 'text_filter')}</option>
                                <option value="CronDateFilter">{$MGLANG->T('label', 'cron_date_filter')}</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-3 control-label">{$MGLANG->T('label', 'filter_title')}</label>
                        <div class="col-sm-9">
                            <input id="filterTitle" class="form-control" type="text" name="filterTitle" value="">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-3 control-label">{$MGLANG->T('label', 'filter_descr')}</label>
                        <div class="col-sm-9">
                            <input id="filterDescr" class="form-control" type="text" name="filterDescr" value="">
                        </div>
                    </div>

                    <div id="dropdownFilterValuesDiv" class="form-group" hidden="">
                        <label class="col-sm-3 control-label">{$MGLANG->T('label', 'dropdown_values')}</label>
                        <div class="col-sm-8">
                            <input class="form-control" id="dropdownFilterValues" type="text" value="">                                    
                        </div>
                        <i class="col-sm-1 fa fa-question-circle" data-toggle="tooltip" title="{$MGLANG->T('label', 'dropdown_values_info')}"></i>
                    </div>

                    <div id="filterHTML" style="margin-top: 50px !important;"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" data-modal-action="save" id="filtersModalSaveButton">{$MGLANG->T('button','save')}</button>
            </div>
        </div>
    </div>
</div>

<style>
    .draggable{ min-width: 10px; min-height: 25px; padding: 5px; display: inline-block; margin: 2px; border-radius: 4px;
                /* disable marked text highlighting*/
                -webkit-touch-callout: none; /* iOS Safari */
                -webkit-user-select: none;   /* Chrome/Safari/Opera */
                -khtml-user-select: none;    /* Konqueror */
                -moz-user-select: none;      /* Firefox */
                -ms-user-select: none;       /* Internet Explorer/Edge */
    }
    .dropped { min-width: 10px; display: inline-block; margin: 2px; border-radius: 4px; }
    .contType { display: block; text-align: center; margin-bottom: 15px; }

    .draggable { cursor: move; }
    .over { border: solid 5px grey; }

    #queryDiv, #phpDiv { 
        width: 100%;
        height: 100px;
    }

    .padFix{
        padding-top:8px;
    }

</style>

<script>
    $(document).ready(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>