{include file="orderforms/{$carttpl}/common.tpl"}
<div id="order-standard_cart" class="hostx-cart-body-section">
    <div class="row">
        <div class="cart-body complete-page-body">
            <div class="header-lined">
                <h1 class="font-size-36">{$LANG.orderconfirmation}</h1>
            </div>
            <div class="complete-order-section">
                <i class="far fa-check-circle"></i>
                <p>{$LANG.orderreceived}</p>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="order-confirmation">
                            {$LANG.ordernumberis} <span>{$ordernumber}</span>
                        </div>
                    </div>
                </div>
                <p>{$LANG.orderfinalinstructions}</p>
                {if $expressCheckoutInfo}
                    <div class="alert alert-info text-center">
                        {$expressCheckoutInfo}
                    </div>
                {elseif $expressCheckoutError}
                    <div class="alert alert-danger text-center">
                        {$expressCheckoutError}
                    </div>
                {elseif $invoiceid && !$ispaid}
                    <div class="alert alert-warning text-center">
                        {$LANG.ordercompletebutnotpaid}
                        <br /><br />
                        <a href="{$WEB_ROOT}/viewinvoice.php?id={$invoiceid}" target="_blank" class="alert-link">
                            {$LANG.invoicenumber}{$invoiceid}
                        </a>
                    </div>
                {/if}
                {foreach $addons_html as $addon_html}
                    <div class="order-confirmation-addon-output">
                        {$addon_html}
                    </div>
                {/foreach}
                {if $ispaid}
                    <!-- Enter any HTML code which should be displayed when a user has completed checkout here -->
                    <!-- Common uses of this include conversion and affiliate tracking scripts -->
                {/if}
                <div class="text-center">
                    <a href="{$WEB_ROOT}/clientarea.php" class="btn button-style hx-primary-btn">
                        {$LANG.orderForm.continueToClientArea}
                        &nbsp;<i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
                {if $hasRecommendations}
                    {include file="orderforms/{$carttpl}/includes/product-recommendations.tpl"}
                {/if}
            </div>
        </div>
    </div>
</div>
